/*
<samplecode>
  <abstract>
  Data type to represent a saved-game record, including an ID and the saved game.
  </abstract>
</samplecode>
*/

import Foundation

@Observable class SaveGameRecord {
    public typealias LocalIdentifier = UInt
    
    let localIdentifier: LocalIdentifier
    
    var game: SaveGame
    
    internal init(localIdentifier: UInt,
                  game: SaveGame) {
        self.localIdentifier = localIdentifier
        self.game = game
    }
}

// MARK: - Equatable

extension SaveGameRecord: Equatable {
    static func == (lhs: SaveGameRecord, rhs: SaveGameRecord) -> Bool {
        return lhs.localIdentifier == rhs.localIdentifier &&
        lhs.game == rhs.game
    }
}

// MARK: - Identifiable

extension SaveGameRecord: Identifiable {
    var id: LocalIdentifier { localIdentifier }
}
